#L04_09b.py
#Kolbengeschwindigkeit mit Numdifftools berechnen
import numpy as np
import matplotlib.pyplot as plt
from numdifftools import Derivative
n = 50 #Drehfrequenz 1/s
r = 0.1 #Radius in m
l = 0.8 #Länge der Antriebskurbel in m
#Weg des Kolbens
def x(t):
    w=2*np.pi*n
    return r*np.cos(w*t) + l*np.sqrt(1.0-(r/l)**2*np.sin(w*t)**2)
#Geschwindigkeit des Kolbens
def v(t):
    df=Derivative(x,order=10,n=1)
    return df(t)
#Beschleunigung
def a(t):
    df=Derivative(v,order=10,n=1)
    return df(t) #Lösung nicht akzeptabel
#Grafikbereich 
fig, ax = plt.subplots(3,1,figsize=(8,8))
t=np.linspace(0,1/n,500)*1e3 #Umwandlung in Millisekunden
ax[0].plot(t,x(t))
ax[1].plot(t,v(t),'b-')
ax[2].plot(t,a(t),'r-')
#Beschriftungen
ax[0].set(xlabel='$t$ in ms',ylabel='$x$ in m',title='Weg des Kolbens')
ax[1].set(xlabel='$t$ in ms',ylabel='$v$ in m/s',title='Kolbengeschwindigkeit')
ax[2].set(xlabel='$t$ in ms',ylabel=r'$a$ in m/$\rm s^{2}$',title='Kolbenbeschleunigung')
fig.tight_layout()
plt.show()
