#sld_wurf1.py
import numpy as np
import matplotlib.pyplot as plt
from matplotlib.widgets import Slider
#Daten
v0=20         #Anfangsgeschwindigkeit
wurfwinkel=45 #in °
g=9.81        #Erdbeschleunigung in m/s^2
#Berechnungen
alpha=np.radians(wurfwinkel)
tw=2*v0*np.sin(alpha)/g
xmax=v0**2*np.sin(2*alpha)/g      #maximale Weite
ymax=v0**2*np.sin(alpha)**2/(2*g) #maximale Höhe
sy=6.4/4.8 #Breite, Höhe
breite=8
hoehe=sy*breite*ymax/xmax
#x,y-Werte
def f(t):
    x=v0*np.cos(alpha)*t
    y=v0*np.sin(alpha)*t-g*t**2/2
    return x,y
#Betrag der Geschwindigkeit
def v(t):
    vx=v0*np.cos(alpha)
    vy=v0*np.sin(alpha)-g*t
    return np.hypot(vx,vy)
#Slider abfragen
def update(val):
    t = sldPunkt.val
    x,y=f(t)
    txtV.set_text('$v$ = %.2f m/s' %v(t))
    punkt.set_data([x],[y])
#Grafikbereich
label='Momentangeschwindigkeit schiefer Wurf'
fig, ax=plt.subplots(figsize=(breite,hoehe),label=label)
fig.subplots_adjust(left=0.08,bottom=0.28)
txtV=ax.text(0.5,9.5,'$v$ = %.2f m/s' %14.14)
ax.axis([0,xmax,0,ymax+1])
t=np.linspace(0,tw)
x,y=f(t)
ax.plot(x,y) #Bahnkurve
x0,y0=f(1.4)
punkt, = ax.plot(x0,y0,'ro') #Punkt
xyPunkt=fig.add_axes([0.08, 0.08, 0.82, 0.03])
sldPunkt=Slider(xyPunkt,'t',0,tw,valinit=1.4,valstep=0.01)
sldPunkt.on_changed(update)
ax.set_xlabel('$x$ in m')
ax.set_ylabel('$y$ in m')
plt.show()


