#vp_bewegung_geradlinig.py
#!/usr/bin/env python3
from vpython import *
scene.title="<h3>Geradlinige Bewegung</h3>"
breite=10.  #Breite der Bodenplatte
hoehe=0.2   #Dicke der Bodenplatte
tiefe=2     #Tiefe der Bodenplatte
wuerfel=1.2 #Breite des Wuerfels
scene.width =640 #Standardwert: 640 Pixel
scene.height=300 #Standardwert: 400 Pixel
scene.userzoom = False    #kein Zoom
#scene.userspin=False
#Zeichenfläche, x,y,z
scene.center=vector(breite/2,-1,0)
scene.background = color.white
#boolesche Varablen
laeuft = False
beschleunigung=False
#Auswahl für Beschleunigung
def auswahl(r):
    global beschleunigung   #globale Variable
    if r.checked==True:     #Überprüfen auf Gleichheit
        beschleunigung=True #Zuweisung
    else:
        beschleunigung=False
#Animation anhalten    
def startStop(b):
    global laeuft
    laeuft = not laeuft
    if laeuft: b.text = "Stop"
    else: b.text = "Start"
#Unterlage und Würfel, x0,y0,z0,Laenge, Hoehe, Tiefe
unterlage=box(size=vector(breite,hoehe,tiefe),color=color.gray(0.8))
unterlage.pos=vector(breite/2,-wuerfel/2-hoehe/2,0) #Position der Unterlage
koerper=box(size=vector(wuerfel,wuerfel,wuerfel),color=color.red) #Masse
koerper.pos = vector(wuerfel/2,0,0) #Anfangsposition der Masse
#Steuerelemente
rbtB=radio(bind=auswahl,checked=False,text=" beschleunigt ")
button(bind=startStop,text="Start",pos=scene.caption_anchor )
#Ausgaben als Label
lblWeg = label()
lblZeit = label()
lblWeg.pos = unterlage.pos + vector(0,-2.0,0)
lblZeit.pos = unterlage.pos + vector(0,-2.6,0)
#Daten
a = 1.0    #Beschleunigung m/s^2
v = 1.0    #Geschwindigkeit m/s
dt = 0.01
t=0
x=0
tmax=(breite-wuerfel)/v
#Animation
while True:
    rate(1/dt)
    if laeuft:
        if beschleunigung:
            x=a*t**2/2 #beschleunigte Bewegung
            koerper.pos = vector(x+wuerfel/2,0,0)
            t=t+dt
        else:        
            x=v*t     #gleichförmige Bewegung
            koerper.pos = vector(x+wuerfel/2,0,0)
            t=t+dt
    if x>=breite - wuerfel:
        t=0
    #Textausgabe
    lblWeg.text = '<em>x</em> = %.2f m' %x
    lblZeit.text = '<em>t</em> = %.2f s' %t