#vp_kreisbewegung.py
#!/usr/bin/env python3
from vpython import *
scene.title="<h3>Rotierende Kugel</h3>"
scene.width=scene.height=500 #Standardwerte: 640x400 Pixel
scene.background=color.white
scene.userspin=False #Drehung der Scene wird unterdrückt
scene.center=vector(0,0,0)
scene.autoscale=False
r=2.135/2. #Radius in m
scene.range = 1.2*r
#
laeuft = False
#
def startStop(b):
    global laeuft
    laeuft = not laeuft
    if laeuft: b.text = "Stop"
    else: b.text = "Start"
#
def periodendauer(s):
    txtA.text = "{:1.2f}".format(s.value)
#Hammer=Kugel+Seil
kugel=sphere(pos=vec(-r,0,0),radius=r/20,color=color.red)
seil=cylinder(pos=vec(0,0,0),axis=vector(-r,0,0),radius=r/200)
#hammer=compound([kugel,seil],pos=vec(-r,0,0),axis=vec(1,0,0))#funktioniert nicht mehr
#Slider
scene.append_to_caption("\n\n")
scene.caption="\n  Umlaufzeit ändern:\n\n"
sldT=slider(min=1,max=10,value=5,length=500,bind=periodendauer,right=4) #Slider für Periodendauer
txtA=wtext(text="{:2.1f}".format(sldT.value))
scene.append_to_caption(" s\n\n")
#Start-Stop-Button
button(text="Start",bind=startStop,pos=scene.caption_anchor)
#Label
lblR=label(pos=vec(-r,1.1,0),text='<em>R</em>  = %.1f m' %r)   #Radius
lblZeit=label(pos=vec(-r,-1.12*r,0),text='<em>t</em>  = 0 s')  #Zeit
lblW=label(pos=vec(-0.42,-1.12*r,0),text='<em>\u03C9</em>  = 0 1/s') #Winkelgeschwindigkeit
lblV=label(pos=vec(0.18,-1.12*r,0),text='<em>v</em>  = 0 m/s') #Geschwindigkeit
lblA=label(pos=vec(0.9,-1.12*r,0),text='<em>a</em><sub>r</sub>  = 0 m/s<sup>2</sup>')#Radialbescheunigung
#
dt=0.01 #
t=w=0
while True:
    rate(1.0/dt)
    if laeuft:
        T=sldT.value #Drehfrequenz, Drehzahl
        w=2*pi/T     #Winkelgeschwindigkeit
        v=w*r        #Bahngeschwindigkeit
        a=w**2*r     #Radialbeschleunigung, Zentripetalbeschleunigung
        seil.rotate(axis=vec(0,0,1),angle=w*dt,origin=vec(0,0,0))
        kugel.rotate(axis=vec(0,0,1),angle=w*dt,origin=vec(0,0,0))
        lblZeit.text= '<em>t</em> = %.2f s' %t  #Zeit
        lblW.text=    '<em>\u03C9</em> = %.2f  1/s' %w  #Winkelgeschwindigkeit
        lblV.text= '<em>v</em> = %.2f m/s' %v      #Bahngeschwindigkeit
        lblA.text= '<em>a</em><sub>r</sub> = %.2f m/s^2' %a    #Radialbeschleunigung
        t=t+dt
        
        
'''
Daten zum Hammerwurf
Kreisdurchmesser: 2,135 m
Masse der Kugel: 7,26 kg
Abfluggeschwindigkeit: 28 m/s für eine Wurfweite von 74 m
Abwurfwinkel: 45°
'''