#diff_wurfparabel.py
import numpy as np
import matplotlib.pyplot as plt
#Daten
alpha=45 #Abwurfwinkel
v0=28    #Afangsgeschwindigkeit
g=9.81   #Erdbeschleunigung
alpha=np.radians(alpha)
xw=v0**2*np.sin(2*alpha)/g      #Wurfweite
tw=2*v0*np.sin(alpha)/g         #Wurfzeit
hw=v0**2*np.sin(alpha)**2/(2*g) #Wurfhöhe
#zentraler Differenzenquotient
def diff(t,f,h=1e-6):
    return (f(t+h)-f(t-h))/(2*h)
#Wurfhöhe: y=f(t)
def y(t):
    return v0*np.sin(alpha)*t - 1/2*g*t**2
#Geschwindigkeit der y-Komponente
def v(t):
    return diff(t,y)
    #return v0*np.sin(alpha) - g*t #zur Kontrolle
#Beschleunigung
def a(t):
    return diff(t,v)
#Grafikbereich
fig,ax=plt.subplots(3,1,figsize=(10,8),label='Schiefer Wurf')
t=np.linspace(0,tw,500)
ax[0].plot(t,y(t),'b-',lw=2)
ax[1].plot(t,v(t),'r-',lw=2)
ax[2].plot(t,a(t),'r-',lw=2)
ax[2].set_ylim(-12,1)
#Beschriftungen
ax[0].set_title('Wurfweite %2.1f m' %xw)
ax[1].set_title('Geschwindigkeit der y-Komponente')
ax[2].set_title('Beschleunigung der y-Komponente')
ax[0].set_ylabel(r'$y\left( t \right)$')
ax[1].set_ylabel(r'$v_y\left( t \right)$')
ax[2].set_ylabel(r'$a_y\left( t \right)$')
ax[2].set_xlabel('$t$ in s')
fig.tight_layout()
plt.show()

#fig.savefig("/Users/veit/documents/Python_Mechanik_01/zusatz/diff_wurfparabel.svg")

'''
from numdifftools import Derivative
def v(t):
    df=Derivative(y,n=1)
    return df(t)
'''