#03_001.py
#Kugel auf Ebene, Trägheitsgesetz
import matplotlib as mpl
import matplotlib.pyplot as plt
from matplotlib.patches import FancyArrowPatch,ArrowStyle
#Figure und Axes Objekte erzeugen
fig, ax = plt.subplots(figsize=(6,3))
#x1,x2,y1,y2
ax.axis([-1,81,-5,15])
#xy,Radius
kugel = mpl.patches.Circle((4,7),4,color='red')
#x1,y1,x2,y2
boden = mpl.patches.Rectangle((0,0.70),75,2.0,fill=True,lw=2,color='gray')
#Ursprung x,y,dx,dy,breite
ax.text(20,6.5,r"$v = const.$",fontsize='12')
#x,y,dx,dy
spitze = ArrowStyle.Simple(head_length=8,head_width=4)
pfeilV = FancyArrowPatch((8,7),(20,7),color='blue',arrowstyle=spitze)
#Objekte darstellen
ax.add_patch(kugel)
ax.add_patch(boden)
ax.add_patch(pfeilV)
ax.axis('off')
ax.set_aspect('equal')
fig.tight_layout()
plt.show()


