#03_002.py
#Rechteck auf Ebene, Kraftgesetz
import matplotlib as mpl
import matplotlib.pyplot as plt
from matplotlib.patches import FancyArrowPatch,ArrowStyle
#Figure und Axes Objekte erzeugen
fig, ax = plt.subplots(figsize=(6,3))
#x1,x2,y1,y2
ax.axis([0,80,0,20])
#x1,y1,x2,y2
masse = mpl.patches.Rectangle((30,2.1),20,12,fill=False,lw=1,color='black')
boden = mpl.patches.Rectangle((0,0),80,2,fill=True,lw=1,color='lightgray')
#x,y-Position, Text
ax.text(23,9,r"$\overrightarrow{F}$",color='r',fontsize='12')
ax.text(38,7.5,r"$m$",color='r',fontsize='12')
ax.text(53,9,r"$\overrightarrow{a}$",color='r',fontsize='12')
#Position A, Position B
spitze = ArrowStyle.Simple(head_length=8,head_width=4)
pfeilF= FancyArrowPatch((20,8),(30,8),color='blue',arrowstyle=spitze)
pfeilA= FancyArrowPatch((50,8),(60,8),color='blue',arrowstyle=spitze)
#Objekte darstellen
ax.add_patch(masse)
ax.add_patch(boden)
ax.add_patch(pfeilF)
ax.add_patch(pfeilA)
ax.axis('off')
ax.set_aspect('equal')
fig.tight_layout()
plt.show()



