#abb_05_08.py
#bremsen v=f(t)
import numpy as np
import matplotlib.pyplot as plt
#
v0=10
tb=5 #Bremszeit
#
def geschwindigkeit(t):
    return v0 - v0/tb*t
#Grafikbereich
fig, ax = plt.subplots(label='Bremsvorgang')
t=np.linspace(0,5,100)
ax.set_xlim(0,5)
ax.set_ylim(0,10)
ax.plot(t,geschwindigkeit(t),'r-')
ax.text(4,0.6,'$-a$')
ax.set(xlabel='$t$ in s',ylabel='$v$ in m/s')
# fig.savefig("/Users/veit/documents/Python_Mechanik/Bilder/48223_05-NF008.svg")
# fig.savefig("/Users/veit/documents/Python_Mechanik/Bilder/48223_05-NF008.pdf")
plt.show()