#03_003.py
#Rechteck auf Ebene, actio=reactio
import matplotlib as mpl
import matplotlib.pyplot as plt
from matplotlib.patches import FancyArrowPatch,ArrowStyle
#Figure und Axes Objekte erzeugen
fig, ax = plt.subplots(figsize=(6,3))
#x1,x2,y1,y2
ax.axis([0,80,-20,30])
#x1,y1,x2,y2
masse = mpl.patches.Rectangle((30,2.15),20,12,fill=False,lw=1,color='black')
boden = mpl.patches.Rectangle((0,0),80,2,fill=True,lw=1,color='lightgray')
#x,y-Position, Text
ax.text(42,21,r"$\overrightarrow{F}$",color='r',fontsize='12')
ax.text(39,7.5,r"$m$",color='r',fontsize='12')
ax.text(42,-10,r"$\overrightarrow{F}$",color='r',fontsize='12')
#Position A, Position B
spitze = ArrowStyle.Simple(head_length=8,head_width=4)
pfeilF1= FancyArrowPatch((40,30),(40,14),color='blue',arrowstyle=spitze)
pfeilF2= FancyArrowPatch((40,-15.5),(40,-0.5),color='blue',arrowstyle=spitze)
#Objekte darstellen
ax.add_patch(masse)
ax.add_patch(boden)
ax.add_patch(pfeilF1)
ax.add_patch(pfeilF2)
ax.axis('off')
ax.set_aspect('equal')
fig.tight_layout()
plt.show()