#ani_wurf_real.py
import numpy as np
import matplotlib.pyplot as plt
from matplotlib.animation import FuncAnimation
from scipy.integrate import solve_ivp
#Daten
m=0.45    #Masse in kg
d=0.22    #Durchmesser der Kugel in m
cw=0.2    #Strömungswiderstandskoeffizient für Kugel
v0=30     #m/s
winkel=45 #°
rho=1.225 #Dichte von Luft kg/m^3
g=9.81    #m/s^2
#Berechnungen
A=np.pi*(d/2)**2 #Querschitt der Kugel
b=1/2*rho*cw*A   #Reibungskonstante kg/m
alpha=np.radians(winkel)
xmax=v0**2*np.sin(2*alpha)/g      #Wurfweite
ymax=v0**2*np.sin(alpha)**2/(2*g) #Wurfhöhe
tmax=2*v0*np.sin(alpha)/g         #Wurfzeit
#ideale Wurfbahn: x,y = f(t)
def wurf_ideal(t,v0,alpha):
    x = v0*np.cos(alpha)*t
    y = v0*np.sin(alpha)*t - g/2*t**2
    return x,y
#Definitition der DGL
def dgl(t,anfangswerte,m,b):
    x,y,vx,vy = anfangswerte #für jede Gleichung einen Anfangswert
    dvx_dt = - b*vx*np.sqrt(vx**2 + vy**2)/m     #Beschleunigung in x-Richtung
    dvy_dt = - g - b*vy*np.sqrt(vx**2 + vy**2)/m #Beschleunigung in y-Richtung
    dx_dt = vx #Geschwindigkeit in x-Richtung
    dy_dt = vy #Geschwindigkeit in y-Richtung
    return dx_dt,dy_dt,dvx_dt,dvy_dt
#Lösung der DGL
dt=0.01  #Zeitschrittweite
y0=[0,0,v0*np.cos(alpha),v0*np.sin(alpha)] #Anfangswerte
t=np.arange(0,tmax,dt)
z=solve_ivp(dgl,[0,tmax],y0,args=(m,b),dense_output=True)
#Wurfbahn berechnen
def wurfbahn(i):
    t=i*dt
    x,y,vx,vy = z.sol(t)
    ball.set_data([x],[y])
    return ball,
#Grafikbereich
fig,ax=plt.subplots(figsize=(8,4))
ax.axis([0,1.05*xmax,0,1.05*ymax])
x,y = wurf_ideal(t,v0,alpha) 
ax.plot(x,y,'b-.') #statische Bahnkurve zeichnen
ball, = ax.plot([],[],'ko',markersize=10)  #Ball
ani=FuncAnimation(fig,wurfbahn,frames=t.size,interval=20,blit=True)#Animation
ax.set(xlabel="$x$ in m",ylabel="$y$ in m")
plt.show()


'''
Daten für Fußball
Umfang 68 bis 70 cm
Durchmesser: 22 cm
Masse 410 bis 450 g
cw-Wert für Kugel: 0.1 bis 0.4, Kuchling, Tabelle 7, S.622
Länge eines Fussballfelds 105 m
'''


