#dgl_fall.py
import numpy as np
import matplotlib.pyplot as plt
#Daten
m=0.45    #Masse der Kugel in kg
d=0.22    #Durchmesser der Kugel in Meter
cw=0.2    #Strömungswiderstandskoeffizient
rho=1.225 #Luftdichte in kg/m^3
g=9.81    #Erdbeschleunigung in m/s^2
tmax=10   #Zeitintervall
#Berechnungen
A=np.pi*(d/2)**2 #Querschitt der Kugel
b=1/2*rho*cw*A   #Konstante kg/m
#Endgeschwindigkeit
ve=np.sqrt((2*m*g)/(cw*rho*A)) 
#Anfangswerte
t=v=s=0         
dt=0.01            #Zeitschrittweite
lt,lv,ls=[],[],[]  #drei leere Listen
#Lösung der DGL
while t<=tmax:  
    v = v + g*dt - b*v**2/m*dt #Geschwindigkeit
    s = s + v*dt               #Weg
    lt.append(t)
    lv.append(v)
    ls.append(s)
    t = t + dt
#Grafikbereich
fig,ax =plt.subplots(2,1,figsize=(8,6))
t=np.arange(0,tmax,dt)
ax[0].plot(lt,lv,'b-')  #Fallgeschwindigkeit
ax[1].plot(lt,ls,'r-')  #Weg
#Beschriftungen
ax[0].set(ylabel='$v$ in m/s',title='Geschwindigkeit')
ax[1].set(xlabel='$t$ in s',ylabel='$s$ in m',title='Weg')
fig.tight_layout()
print("Endgeschwindigkeit",round(ve,3),"m/s")
plt.show()


'''
Daten für Fußball
Umfang 68 bis 70 cm
Durchmesser: 22 cm
Masse 410 bis 450 g
cw-Wert für Kugel: 0.1 bis 0.4 Kuchling, Tabelle 7, S.622
Höhe des Commerzbank Towers in Frankfurt 300 m
'''
