#L_05_05.py
#Luftwiderstand für Fahrradfahrer
import numpy as np
import matplotlib.pyplot as plt
A=0.6 #m^2  #Wirksamer Querschnitt des Fahrradfahrers
cw=0.6    #Strömungswiderstandskoeffizient
rho=1.225 #Luftdichte in kg/m^3
tmax=10   #Zeitintervall
#Berechnungen
v=np.linspace(0,10,100)
Fw=0.5*rho*cw*A*v**2 #Luftwiderstand
#Grafikbereich
fig, ax = plt.subplots(figsize=(8,6))
ax.plot(v,Fw,'b-')
ax.grid(True)
ax.set(xlabel='$v$ in m/s',ylabel='$F_{w}$ in N')
plt.show()