#L_05_06.py
#Vergleich der Genauigkeit des Euler-Verfahrens mit der analytischen Lösung
import numpy as np
import matplotlib.pyplot as plt
#Zeitschrittweite ändern
dt=0.1     
#Daten
m=0.45    #Masse der Kugel in kg
d=0.22    #Durchmesser der Kugel in Meter
rho=1.225 #Luftdichte
cw=0.2    #Strömungswiderstandskoeffizient
g=9.81    #Erdbeschleunigung in m/s^2
tmax=10   #Zeitintervall
#Berechnungen
A=np.pi*(d/2)**2     #Querschitt der Kugel
b=1/2*rho*cw*A  #Konstante kg/m
ve=np.sqrt((2*m*g)/(cw*rho*A)) #Endgeschwindigkeit
#exater Verlauf
def geschwindigkeit(t,ve):
    return ve*np.tanh(g/ve*t)
#Anfangswerte
t=v=s=0         
lt,lv=[],[]  #zwei leere Listen
#Lösung der DGL
while t<=tmax:  
    v = v + g*dt - b*v**2/m*dt #Geschwindigkeit
    lt.append(t)
    lv.append(v)
    t = t + dt
#Grafikbereich
fig,ax =plt.subplots(figsize=(8,6))
t=np.arange(0,tmax,dt)
ax.plot(lt,lv,'b-.',label='Euler-Verfahren')  #Euler-Verfahren
ax.plot(t,geschwindigkeit(t,ve),'k-',label='gneau') #genau
#Beschriftungen
ax.set(xlabel='$t$ in s', ylabel='$v$ in m/s',title='Geschwindigkeit')
ax.legend()
fig.tight_layout()
print("Endgeschwindigkeit",round(ve,3),"m/s")
plt.show()


'''
Daten für Fußball
Umfang 68 bis 70 cm
Durchmesser: 22 cm
Masse 410 bis 450 g
cw-Wert für Kugel: 0.1 bis 0.4 Kuchling, Tabelle 7, S.622
Höhe des Commerzbank Towers in Frankfurt 300 m
'''
