#L_05_08.py
#Simulation Hammerwurf
import numpy as np
import matplotlib.pyplot as plt
from scipy.integrate import solve_ivp
#Daten
m=7.26    #Masse der Kugel in kg
d=0.124   #Durchmesser der Kugel in Meter
cw=0.2    #Strömungswiderstandskoeffizient
v0=28     #m/s
winkel=45 #Abwurfwinkel in °
rho=1.225 #Luftdichte in kg/m^3
g=9.81    #Erdbeschleunigung in m/s^2
#Berechnungen
A=np.pi*(d/2)**2 #Querschitt der Kugel
b=1/2*rho*cw*A   #Reibungskonstante kg/m
alpha=np.radians(winkel)
xmax=v0**2*np.sin(2*alpha)/g
ymax=v0**2*np.sin(alpha)**2/(2*g)
tmax=2*v0*np.sin(alpha)/g  #Wurfzeit
#Definitition der DGL
def dgl(t,anfangswerte,m,b):
    x,y,vx,vy = anfangswerte #für jede Gleichung einen Anfangswert
    dvx_dt = - b*vx*np.sqrt(vx**2 + vy**2)/m     #Beschleunigung in x-Richtung
    dvy_dt = - g - b*vy*np.sqrt(vx**2 + vy**2)/m #Beschleunigung in y-Richtung
    dx_dt = vx #Geschwindigkeit in x-Richtung
    dy_dt = vy #Geschwindigkeit in y-Richtung
    return dx_dt,dy_dt,dvx_dt,dvy_dt
#ohne Luftwiderstand
def wurf_ideal(t,v0,alpha):
    x = v0*np.cos(alpha)*t
    y = v0*np.sin(alpha)*t - g/2*t**2
    return x,y
#Lösung der DGL
vx0=v0*np.cos(alpha)
vy0=v0*np.sin(alpha)  
dt=0.005          #Zeitschrittweite
y0=[0,0,vx0,vy0]  #Anfangswerte: x=0, y=0
ti=[0,tmax]       #Integrationsintervall
t=np.arange(0,tmax,dt)
z=solve_ivp(dgl,ti,y0,args=(m,b),dense_output=True)
x,y,vx,vy = z.sol(t)
#Grafikbereich
fig, ax=plt.subplots(figsize=(8,4))
ax.set_xlim(0,1.05*xmax)
ax.set_ylim(0,1.05*ymax)
#reale Bahnkurve
ax.plot(x,y,'r-') 
#ideale Bahnkurve
x2,y2 = wurf_ideal(t,v0,alpha)
ax.plot(x2,y2,'b-.')
#Beschriftungen
ax.set(xlabel='$x$ in m', ylabel='$y$ in m')
plt.show()



