#quad_bremsen.py
import numpy as np
import matplotlib.pyplot as plt
from scipy.integrate import quad
#Daten
v0=12.5 #m/s
a=-5    #m/s
m=100   #kg
#Beschleunigung
def beschleunigung(t):
    return 0*t+a
#Kraft
def kraft(t):
    return m*beschleunigung(t)
#Geschwindigkeit
@np.vectorize
def geschwindigkeit(t):
    return quad(beschleunigung,0,t)[0] + v0
#Bremsweg
@np.vectorize
def bremsweg(t):
    return quad(geschwindigkeit,0,t)[0]
#Grafikbereich
fig, ax =plt.subplots(2,2,figsize=(8,8),label='Bremsweg')
tb=abs(v0/a)
t=np.linspace(0,tb,200)
ax[0,0].plot(t,beschleunigung(t),'g-') #Beschleunigung
ax[0,1].plot(t,kraft(t),'k-')               #Kraft
ax[1,0].plot(t,geschwindigkeit(t),'b') #Geschwindigkeit
ax[1,1].plot(t,bremsweg(t),'r-')       #Bremsweg
#Beschriftungen
ax[0,0].set(ylabel=r'$a$ in m/$\rm s^{2}$',title='Beschleunigung')
ax[0,1].set(ylabel='$F$ in N',title='Kraft')
ax[1,0].set(xlabel='$t$ in s',ylabel='$v$ in m/s',title='Geschwindigkeit')
ax[1,1].set(xlabel='$t$ in s',ylabel='$s$ in m',title='Weg')
fig.tight_layout()
plt.show()


