#sci_fall.py
import numpy as np
import matplotlib.pyplot as plt
from scipy.integrate import solve_ivp
#Daten
m=0.45    #Masse der Kugel in kg
d=0.22    #Durchmesser der Kugel in Meter
cw=0.2    #Strömungswiderstandskoeffizient
rho=1.225 #Luftdichte in kg/m^3
g=9.81    #Erdbeschleunigung in m/s^2
tmax=10   #Zeitintervall
#Berechnungen
A=np.pi*(d/2)**2 #Querschitt der Kugel
b=1/2*rho*cw*A   #Reibungskonstante
#Definitition der DGL
def dgl(t,anfangswerte,m,b):
    s,v = anfangswerte
    ds_dt=v              #Geschwindigkeit
    dv_dt = g - b*v**2/m #Beschleunigung
    return ds_dt,dv_dt
#Lösung der DGL
dt=0.001    #Zeitschrittweite
y0=[0,0]    #Anfangswerte für Weg und Geschwindigkeit
ti=[0,tmax] #Integrationsintervall
t=np.arange(0,tmax,dt)
z=solve_ivp(dgl,ti,y0,args=(m,b),dense_output=True)
s,v = z.sol(t)
#Grafikbereich
fig, ax=plt.subplots(2,1,figsize=(8,6),label='Fall mit Luftwiderstand')
ax[0].plot(t,v,'b-') #Funktionsplot für Geschwindigkeit
ax[1].plot(t,s,'r-') #Funktionsplot für Weg
#Beschriftungen
ax[0].set(ylabel='$v$ in m/s',title='Geschwindigkeit')
ax[1].set(xlabel='$t$ in s',ylabel='$s$ in m',title='Weg')
fig.tight_layout()
plt.show()

# z=solve_ivp(dgl,ti,y0,args=(m,b),t_eval=t)
# s,v = z.y

#Listig 5.11
'''
Daten für Fußball
Umfang 68 bis 70 cm
Durchmesser: 22 cm
Masse 410 bis 450 g
cw-Wert für Kugel: 0.1 bis 0.4 Kuchling, Tabelle 7, S.622
Höhe des Commerzbank Towers in Frankfurt 300 m
'''
