#sci_federkonstante.py
import numpy as np
import matplotlib.pyplot as plt
from scipy.stats import linregress
#Daten
g=10  #m/s^2
m=np.array([0,100,200,300,400,500]) #Massen in Gramm
F=m*0.001*g #Umwandlung in kg
s=np.array([0,0.9,2.1,2.9,4.1,4.9]) #Weg in cm
#Grafikbereich
fig, ax = plt.subplots()
#Steigung,Schnittpunkt mit y-Achse, 
k,F0,r,p,e = linregress(s,F)
ax.plot(s,F, 'rx')    #Messpunkte
ax.plot(s,k*s + F0,'b-') #Ausgleichsgerade
#Beschriftungen
ax.text(1.3,5.5,'Federkonstante k = %.1f N/cm' %k)
ax.set(xlabel='$s$ in cm', ylabel='$F$ in N')
plt.show()

#ax.scatter(s,F,marker='x',color='red') #Ersatz für Zeile 11