#sld_federkraft.py
import numpy as np
import matplotlib.pyplot as plt
from matplotlib.widgets import Slider
#Daten
smax=5   #cm
k=1      #N/cm
Fmax=k*smax
#Hookesches Gesetz
def federkraft(s,k):
    return k*s
#Slider abfragen
def update(val):
    s = sldS.val #Weg in cm
    sg=np.arange(0,s,0.001) #Array für Funktionsplot
    F=k*s        #Federkraft für Textausgabe in N
    txtF.set_text('$F$ = %.1f N' %F)
    txtS.set_text('$s$ = %.1f cm' %s)
    punkt.set_data([s],[F])
    weg.set_data([sg],[federkraft(sg,k)])
    h_linie.set_data([0,s],[F,F]) #horizontale Linie
    v_linie.set_data([s,s],[0,F]) #vertikale Linie
#Grafikbereich
fig, ax=plt.subplots(figsize=(8,6))
ax.axis([0,1.1*smax,0,1.1*Fmax])
txtF=ax.text(2,5.6,'$F$ = %.1f N' %2)  #Kraft
txtS=ax.text(3,5.6,'$s$ = %.1f cm' %2) #Weg
weg, = ax.plot([],[],'b-')
punkt, = ax.plot([],[],'ro') #roter Punkt
h_linie, = ax.plot([],[],'k--',lw=0.75)
v_linie, = ax.plot([],[],'k--',lw=0.75)
fig.subplots_adjust(left=0.12,bottom=0.18)
xyS=fig.add_axes([0.12, 0.02, 0.8, 0.03])
sldS=Slider(xyS,'$s$ in cm',0,smax,valinit=smax//2,valstep=0.1)
sldS.on_changed(update)
#Beschriftungen
ax.set_xlabel('$s$ in cm')
ax.set_ylabel('$F$ in N')
plt.show()


##
# sg=np.arange(0,smax//2,0.001)
# weg, = ax.plot(sg,federkraft(sg,k),'b-')
# punkt, = ax.plot(smax//2,Fmax//2,'ro') #roter Punkt
# h_linie, = ax.plot([0,smax//2],[Fmax//2,Fmax//2],'k--',lw=0.75)
# v_linie, = ax.plot([smax//2,smax//2],[0,Fmax//2],'k--',lw=0.75)
##

