#abb_06_002.py
#Ortsvektoren
import numpy as np
import matplotlib.pyplot as plt
from matplotlib.widgets import Slider
from matplotlib.patches import FancyArrowPatch,ArrowStyle
xmax,ymax=20,20
#Grafikbereich
fig, ax=plt.subplots()
plt.rc('font', size=12)
ax.axis([0,xmax,0,ymax])
#ax.set_xticks(np.arange(0,xmax,1))
#ax.set_yticks(np.arange(0,ymax,1))
x1,y1=5,10
x2,y2=15,5
Fx,Fy=10,15
#Pfeile
spitze = ArrowStyle.Simple(head_length=8,head_width=4)
#Zugkraft
F = FancyArrowPatch((x1,y1),
                         (Fx,Fy),
                         color='red',arrowstyle=spitze,lw=2)

r1 = FancyArrowPatch((0,0),
                         (x1,y1),
                         color='black',arrowstyle=spitze)

r2 = FancyArrowPatch((0,0),
                         (x2,y2),
                         color='black',arrowstyle=spitze)

r12 = FancyArrowPatch((x1,y1),
                         (x2,y2),
                         color='black',arrowstyle=spitze)

#
ax.add_patch(F)
ax.add_patch(r1)
ax.add_patch(r2)
ax.add_patch(r12)
ax.grid(True)
#Beschriftungen
ax.text(2.9,8.5,'$r_{1}$')
ax.text(13.2,3.5,'$r_{2}$')
ax.text(10.6,8.4,'$r_{12}$')
ax.text(10.2,15.4,'$F$')
ax.text(6.6,10.5,r'$\alpha$')
ax.set_xlabel('$x$')
ax.set_ylabel('$y$')
# fig.savefig("/Users/veit/documents/Python_Mechanik/Bilder/48223_06-NF002.svg")
# fig.savefig("/Users/veit/documents/Python_Mechanik/Bilder/48223_06-NF002.pdf")
plt.show()
