#abb_06_004.py
#Reibungsarbeit
import numpy as np
import matplotlib.pyplot as plt
#Daten
Fn=1000  #Normalkraft in N
smax= 5  #Weg in m
my=0.2   #Gleitreibung
myr=0.02 #Rollreibung
def antriebskraft(s,F):
    return 0*s + F
#
fig, ax = plt.subplots()
plt.rc('font', size=12) 
s=np.linspace(0,smax,100)
F=my*Fn   #Antriebskraft
ax.plot(s,antriebskraft(s,F),'r-')
ax.set_ylim(0,250)
ax.fill_between(s, F,alpha=0.1)
ax.text(2.2,98,r'$W = F\cdot s$')
#Beschriftungen
ax.set_xlabel('$s$ in m')
ax.set_ylabel('$F$ in N')
# fig.savefig("/Users/veit/documents/Python_Mechanik/Bilder/48223_06-NF004.svg")
# fig.savefig("/Users/veit/documents/Python_Mechanik/Bilder/48223_06-NF004.pdf")
plt.show()
