#abb_06_006.py
#Luft- und Rollwiderstand
import numpy as np
import matplotlib.pyplot as plt
from matplotlib.widgets import Slider
#Daten
m=1400      #Masse in kg
cw=0.28     #N/cm
A=2         #Querschittsfläche m^2
my=0.015    #Rollwiderstandsbeiwert
rho=1.225   #Luftdichte
g=9.81
#
def luftwiderstand(v):
    return 1/2*rho*cw*A*v**2
#
def rollwiderstand(v):
    return 0*v + my*g*m
#
fig,ax = plt.subplots()
plt.rc('font', size=12)
v=np.linspace(0,30,300)#m/s
F=luftwiderstand(v)+rollwiderstand(v)
ax.plot(v,luftwiderstand(v),'r-',label='Luftwiderstand')
ax.plot(v,rollwiderstand(v),'b-',label='Rollwiderstand')
ax.plot(v,F,'k-',label='Gesamtwiderstand')
ax.legend()
ax.set_xlabel('$v$ in m/s')
ax.set_ylabel('$F$ in N')
# fig.savefig("/Users/veit/documents/Python_Mechanik/Bilder/48223_06-NF006.svg")
# fig.savefig("/Users/veit/documents/Python_Mechanik/Bilder/48223_06-NF006.pdf")
plt.show()

