#ani_energieerhaltung.py
import numpy as np
import matplotlib.pyplot as plt
from matplotlib.patches import Arc
from matplotlib.animation import FuncAnimation
from scipy.integrate import solve_ivp
#Daten
r = 1.0        #Radius der Kugelschale in m
winkel = 85    #Auslenkwinkel
m=10           #Masse in kg
tmax = 50      #Simulationsdauer
g = 9.81       #m/s^2
w02=g/r        #Quadrat der Kreisfrequenz       
dt = 1e-3      #Zeitschrittweite
#Definition der DGL
def dgl(t,anfangswerte):
    phi,w = anfangswerte
    phi_dt = w
    dw_dt = - w02*np.sin(phi)
    return phi_dt, dw_dt
#Lösung der DGL
y0=[np.radians(winkel), 0.0]  #Anfangswerte
t = np.arange(0, tmax, dt)
z=solve_ivp(dgl,[0,tmax],y0,dense_output=True)
#Animationsfunktion
def kugelbahn(i):
    t=i*dt
    phi,w = z.sol(t) #Trennen der Variablen
    v=r*w            #Berechnnung der Bahngeschwindigkeit
    x,y = r*np.sin(phi),-r*np.cos(phi) #x-y-Koordinaten
    h=r + y
    Epot=m*g*h
    Ekin=m*v**2/2.0
    summe=Epot + Ekin
    txtEpot.set_text(r'$E_{pot}$ = %.1f J' %Epot)
    txtEkin.set_text(r'$E_{kin}$ = %.1f J' %Ekin)
    txtSum.set_text(r'$E_{pot} + E_{kin}$ = %.1f J' %summe)
    kugel.set_data([x],[y])
    return kugel,txtEpot,txtEkin,txtSum
#Grafikbereich
fig,ax= plt.subplots(figsize=(6, 6))
#Kugelschale
ax.plot([-1.06*r,1.06*r],[0,0],'b-')
schale=Arc((0,0),2.12*r,2.12*r,angle=0.0,theta1=180,theta2=360,lw=3,color='b')
ax.add_patch(schale)
#für Textausgabe
txtEpot=ax.text(-r+0.25,r,'%',fontsize=12)
txtEkin=ax.text(-r+0.25,0.85,'',fontsize=12)
txtSum=ax.text(-r,0.70,'',fontsize=12)
ax.axis([-1.1*r,1.1*r,-1.1*r,1.1*r])
ax.set_aspect('equal')
kugel, =  ax.plot([],[], 'ro', markersize='15') #Kugel
ani=FuncAnimation(fig,kugelbahn,frames=t.size,interval=30,blit=True)
ax.set_axis_off()
plt.show()

#Listing 6.7

'''
#Euler-Verfahren
x,y = np.empty(t.size),np.empty(t.size)
v=np.empty(t.size)
x[0]=y[0]=0
for i in range(t.size):
    phi = phi + w*dt           #Auslenkung
    w = w - w02*np.sin(phi)*dt
    v[i]=r*w
    x[i],y[i] = r*np.sin(phi),-r*np.cos(phi) #x-y-Koordinaten
'''



