#L_06_03.py
#Animation des freien Falls.
#Die aktuelle potentielle und kinetische Energie wird angezeigt.
import numpy as np
import matplotlib.pyplot as plt
from matplotlib.animation import FuncAnimation
#Daten
h = 10       #Höhe
m = 10       #Masse
g = 9.81     #m/s^2
dt=0.01      #Zeitschrittweite
#Animationsfunktion
def fall(i):
    t=i*dt
    y = h - 0.5*g*t**2
    v=g*t
    Epot=m*g*y
    Ekin=0.5*m*v**2
    summe=Epot + Ekin
    txtEpot.set_text(r'$E_{pot}$ = %.1f J' %Epot)
    txtEkin.set_text(r'$E_{kin}$ = %.1f J' %Ekin)
    txtSum.set_text(r'$E_{pot} + E_{kin}$ = %.1f J' %summe)
    kugel.set_data([0],[y])
    return kugel,txtEpot,txtEkin,txtSum
#Grafikbereich
fig,ax= plt.subplots(figsize=(8, 8))
ax.axis([-3,3,0,1.2*h])
#für Textausgabe
txtEpot=ax.text(0,1.15*h,'%',fontsize=12)
txtEkin=ax.text(0,1.1*h,'',fontsize=12)
txtSum=ax.text(-1,1.05*h,'',fontsize=12)
tmax=np.sqrt(2*h/g)
t=np.arange(0,tmax,dt)
kugel, =  ax.plot([],[], 'ro', markersize='15') #Kugel
ani=FuncAnimation(fig,fall,frames=t.size,interval=20,blit=True)
ax.set_xticks([])
ax.set_aspect('equal')
ax.set_ylabel('Höhe in m',fontsize=12)
plt.show()





