#sld_energieverbrauch.py
import numpy as np
import matplotlib.pyplot as plt
from matplotlib.widgets import Slider
#Daten
m=1400      #Masse in kg
cw=0.28     #N/cm
A=2         #Querschittsfläche m^2
my=0.015    #Rollwiderstandsbeiwert
smax = 10   #km
vmax = 30   #m/s
rho=1.225   #Luftdichte
g=9.81
Fmax=550
#Slider abfragen
def update(val):
    s = sldS.val #Weg in km
    v = sldV.val #m/s
    Fw=1/2*rho*A*cw*v**2 #Luftwiderstand
    Fr=m*g*my            #Rollreibung
    F=Fw + Fr
    W=F*s                #Arbeit in kJ
    #Textausgaben
    txtF.set_text('$F$ = %.1f N' %F)
    txtS.set_text('$s$ = %.1f km' %s)
    txtW.set_text('$W$ = %.1f kJ' %W)
    #Linien zeichnen
    h_linie.set_data([0,s],[F,F]) #horizontale Linie
    v_linie.set_data([s,s],[0,F])  #vertikale Linie
#Grafikbereich
fig, ax=plt.subplots(figsize=(8,6))
ax.axis([0,1.1*smax,0,1.1*Fmax])
#für Ausgaben
txtF=ax.text(1,Fmax,'$F$ = %.1f N' %343.2)   #Kraft
txtS=ax.text(4,Fmax,'$s$ = %.1f km' %8.0)     #Weg
txtW=ax.text(7,Fmax,'$W$ = %.1f kJ' %2745.7) #Arbeit
#x1,x2,y1,y2
h_linie, = ax.plot([0,8],[343.2,343.2],'k-')
v_linie, = ax.plot([8,8],[0,343.2],'k-')
#Slider
fig.subplots_adjust(left=0.12,bottom=0.18)
xyS=fig.add_axes([0.12, 0.06, 0.8, 0.03])
xyV=fig.add_axes([0.12, 0.02, 0.8, 0.03])
sldS=Slider(xyS,'$s$ in km',0,smax,valinit=8,valstep=0.1)
sldV=Slider(xyV,'$v$ in m/s',0,vmax,valinit=20,valstep=0.1)
sldS.on_changed(update)
sldV.on_changed(update)
#Beschriftungen
ax.set_xlabel('$s$ in km')
ax.set_ylabel('$F$ in N')
plt.show()

'''
Rollwiderstandsbeiwert, Fahrwiderstandszahl
Kuchling: Tabelle 2, Seite 618
'''
