#sld_hubarbeit.py
import matplotlib.pyplot as plt
from matplotlib.widgets import Slider
#Daten
m = 100   #Masse in kg
g = 9.81  #Erdbeschleunigung
hmax = 10  #maximale Höhe in m
#Slider abfragen
def update(val):
    x = sldX.val #m
    y = sldY.val #m
    W=m*g*y      #Arbeit in J
    txtW.set_text('$W$ = %.1f J' %W)
    seil.set_data([x,x],[hmax,y]) #Seil zeichnen
    masse.set_data([x,x],[y,y])   #Punkt zeichnen
#Grafikbereich
fig, ax=plt.subplots(figsize=(8,6))
ax.axis([-3.5,3.5,-0.5,1.05*hmax])
txtW=ax.text(-0.5,11,'$W$ = %.1f J' %(5*g*m))#Arbeit
ax.plot([-3,3],[10.2,10.2],'k-',lw=15,alpha=0.6) #Befestigung
#x1,x2,y1,y2
seil, = ax.plot([0,0],[hmax,5],'r-')
masse, = ax.plot([0,0],[5,5],'ko',markersize=20)
fig.subplots_adjust(left=0.12,bottom=0.18)
xyX=fig.add_axes([0.12, 0.06, 0.8, 0.03])
xyY=fig.add_axes([0.12, 0.02, 0.8, 0.03])
sldX=Slider(xyX,'$x$ in m',-3,3,valinit=0,valstep=0.1)
sldY=Slider(xyY,'$y$ in m',0,0.95*hmax,valinit=5,valstep=0.1)
sldX.on_changed(update)
sldY.on_changed(update)
#Rahmen unsichtbar machen
ax.set_frame_on(True)
ax.set_xticks([])
ax.set_yticks([])
plt.show()

