#sld_spannarbeit.py
import numpy as np
import matplotlib.pyplot as plt
from matplotlib.widgets import Slider
#Daten
smax=5   #cm
k=100    #N/cm
Fmax=k*smax
#Hookesches Gesetz
def federkraft(s,k):
    return k*s
#Slider abfragen
def update(val):
    s = sldS.val #Weg in cm
    sg=np.arange(0,s,0.001) #Array für Funktionsplot
    F=k*s           #Federkraft für Textausgabe in N
    W=1/2*F*s*0.01  #Dreiecksfläche Nm
    txtF.set_text('$F$ = %.1f N'  %F)
    txtS.set_text('$s$ = %.1f cm' %s)
    txtW.set_text('$W$ = %.1f J' %W) #Spannarbeit
    punkt.set_data([s],[F])
    weg.set_data([sg],[federkraft(sg,k)])
    v_linie.set_data([s,s],[0,F]) #vertikale Linie
#Grafikbereich
fig, ax=plt.subplots(figsize=(8,6))
ax.axis([0,1.1*smax,0,1.1*Fmax])
txtF=ax.text(0.5,500,'$F$ = %.1f N' %200)  #Kraft
txtS=ax.text(1.5,500,'$s$ = %.1f cm' %2) #Weg
txtW=ax.text(2.5,500,'$W$ = %.1f J' %2) #Arbeit
weg, = ax.plot([0,2],[0,200],'b-')
punkt, = ax.plot([2,2],[200,200],'ro',zorder=2.5) #roter Punkt
v_linie, = ax.plot([2,2],[0,200],'b-')
fig.subplots_adjust(left=0.12,bottom=0.18)
xyS=fig.add_axes([0.12, 0.02, 0.8, 0.03])
sldS=Slider(xyS,'$s$ in cm',0,smax,valinit=2,valstep=0.1)
sldS.on_changed(update)
#Beschriftungen
ax.set_xlabel('$s$ in cm')
ax.set_ylabel('$F$ in N')
plt.show()

