#!/usr/bin/env python3
#vp_spannarbeit.py
from vpython import *
kf=10   #Federkonstante N/cm
x0=5
#Dehnung ändern
def weg():
    s=sldWeg.value
    feder.axis.x = s
    pfeilF.pos=feder.pos + vector(s,0,0)
    pfeilF.axis.x = s
    F = kf*s  #Federkraft berechnen
    W = F*s/2 #Spannarbeit berechnen
    lblF.text = '<i>F</i> =  %2.1f N' %F  #Kraft
    lblW.text = '<i>W</i> =  %2.1f Nm' %W #Spannarbeit
    txtWeg.text = '\t %2.2f' %s
#Zeichenfläche
scene.title="<h3>Spannarbeit</h3>"
scene.width=800
scene.height=400
scene.center=vector(0,0,0)
scene.range=10
scene.background = color.white
scene.userzoom = False    #kein Zoom
scene.userspin = False
#Wand für Befestigung der Schraubenfeder
wand=box(pos=vec(-10, 0, 0),length=2, height=15, width=2,color=color.black)
#Schraubenfeder
feder=helix(axis=vector(x0,0,0),radius=1.4)
feder.thickness=0.2
feder.coils=10
feder.pos=wand.pos
#Pfeil Zugkraft
pfeilF=arrow(pos=vec(0, 0, 0),axis=vec(x0, 0, 0),color=color.red,round=True)
pfeilF.pos=feder.pos + vector(x0,0,0)
#Label für Ausgabe der Federkräfte
lblF=label(pos=vec(17,-7,0),text='F  = %2.2f °' %0)
lblW=label(pos=vec(17,-9,0),text='W  = %2.2f °' %0)
#****Slider für Wegänderung****
scene.caption = "\nDehnung ändern: \n\n" #Beschriftung des Sliders
#Sliderobjekt für Dehnung erzeugen
sldWeg = slider(bind=weg,min=3, max=10, value=x0, length=700,right=15)
#Textfeld für Ausgabe der Dehnung
txtWeg = wtext(text='\t %2.2f' %sldWeg.value)
#Einheit des Wegs
scene.append_to_caption(" cm\n")
