#sld_kraftstoss.py
import numpy as np
import matplotlib.pyplot as plt
from matplotlib.widgets import Slider
#Daten
m=45e-3   #Masse in kg
alpha=13  #Abschusswinkel
g=9.81    #m/s^2
ymax=10   #Maximum y-Achse
tmax=0.6  #maximale Stoßzeit in ms
alpha=np.radians(alpha)
#Slider abfragen
def update(val):
    ts = sldTs.val      #Stoßzeit in ms
    Fmax = sldFmax.val  #maximale Kraft in kN
    S = 0.5*Fmax*ts     #Kraftstoß in Ns
    v = S/m             #Geschwindigkeit m/s
    xw=v**2*np.sin(2*alpha)/g #Flugweite in m
    #Textausgaben
    txtS.set_text('$S$ = %.1f Ns' %S)
    txtV.set_text('$v$ = %.1f m/s' %v)
    txtXw.set_text('$x_w$ = %.f m' %xw)
    #Linien zeichnen
    linie1.set_data([0,ts/2],[0,Fmax])  #positive Steigung
    linie2.set_data([ts,ts/2],[0,Fmax]) #negative Steigung
#Grafikbereich
fig, ax=plt.subplots(figsize=(8,6))
ax.axis([0,1.1*tmax,0,1.1*ymax])
#für Ausgaben
txtS=ax.text(0.5,ymax,'$S$ = %.1f Ns' %(1/2*ymax*tmax))
txtV=ax.text(0.5,0.94*ymax,'$v$ = %.1f m/s' %(1/2*ymax*tmax/m))#Geschwindigkeit
txtXw=ax.text(0.5,0.87*ymax,'$x_{w}$ = %.1f m' %(199))
#x1,x2,y1,y2
linie1, = ax.plot([0,tmax/2],[0,ymax],'r-')
linie2, = ax.plot([tmax,tmax/2],[0,ymax],'r-')
#Slider
fig.subplots_adjust(left=0.12,bottom=0.18)
xyTs=fig.add_axes([0.12, 0.06, 0.8, 0.03])
sldTs=Slider(xyTs,'$t_s$ in ms',tmax/2,tmax,valinit=tmax,valstep=0.001)
xyFmax=fig.add_axes([0.12, 0.02, 0.8, 0.03])
sldFmax=Slider(xyFmax,'$F_{max}$ in kN',ymax/2,ymax,valinit=ymax,valstep=0.1)
sldTs.on_changed(update)
sldFmax.on_changed(update)
#Beschriftungen
ax.set_xlabel('$t_s$ in ms')
ax.set_ylabel(r'$F$ in kN')
plt.show()


#$\widehat{F}$
