#L08_08.py
'''
Beschleunigungsmoment für Zylinder
'''
import numpy as np
import matplotlib.pyplot as plt
#Daten
d = 0.1   #Durchmesser des Zylinders in m
m = 100   #Masse des Zylinders in kg
ta = 10   #Hochlaufzeit in s
tb = 10   #Bremszeit in in s
tm = 60   #Laufzeit in s
we= 300   #2*np.pi*n/60 #Winkelgeschwindigkeit nach der Hochlaufzeit 1/s
#Winkelbeschleunigungen
alpha1 = we/ta #1.Ableitung = Steigung
alpha2 = we/tb #1.Ableitung = Steigung
J = m*(d/2)**2/2 #Trägheitsmoment des Zylinders
Mb1=J*alpha1     #Beschleunigungsmoment
Mb2=J*alpha2     #Bremsmoment
#Winkelgeschwindigkeit als Funktion der Zeit
@np.vectorize
def winkelgeschwindigkeit(t):
    if t<ta:
        return alpha1*t
    elif t > ta and t < ta + tm:
        return 0*t + we
    elif t > ta+tm:
        return -alpha2*(t-ta-tm-tb)
#Beschleunigungsmoment als Funktion der Zeit
@np.vectorize
def beschleunigungsmoment(t):
    if t<ta:
        return Mb1
    elif t > ta and t < ta + tm:
        return  0*t 
    elif t > ta+tm:
        return -Mb2
#Grafikbereich
fig, ax = plt.subplots(2,1,figsize=(8,6))
t = np.linspace(0,ta+tm+tb,500)
ax[0].plot(t,winkelgeschwindigkeit(t),'b-')
ax[1].plot(t,beschleunigungsmoment(t),'r-')
#Beschriftungen
ax[0].set(ylabel=r'$\omega$ in 1/s',title='Winkelgeschwindigkeit')
ax[1].set(xlabel='$t$ in s',ylabel='$M_b$ in Nm',title='Beschleunigungsmoment')
fig.tight_layout()
# fig.savefig("/Users/veit/documents/Python_Mechanik/Bilder/48223_08-NF010.svg")
# fig.savefig("/Users/veit/documents/Python_Mechanik/Bilder/48223_08-NF010.pdf")
# print(Mb1)
# print(60*we/(2*np.pi))
plt.show()

'''
fig.savefig("/Users/veit/documents/Python_Mechanik/Bilder/48223_08-NF010.svg")
fig.savefig("/Users/veit/documents/Python_Mechanik/Bilder/48223_08-NF010.pdf")
'''

