#!/usr/bin/env python3
#vp_rotationsenergie.py
from vpython import *
scene.width = 500
scene.height = 400
scene.range = 1.3
scene.background = color.white
scene.userzoom = False        
scene.userspin = False
#scene.title = "Rotationsenergie\n"
#Daten der Körper
J=0 #Trägheitsmoment
#Erot=0
l=1 #Länge des Stabes in m
r=1 #Umlaufradius der Kugel in m
a=1 #Breite des Quaders in m
b=1 #Tiefe des Quaders in m
m=1 #Masse der Körper in kg
#Boolsche Variable
running = False
#Entscheidung für Stop oder Start
def startStop(b):
    global running
    running = not running
    if running:
        b.text = "Stop"
    else:
        b.text = "Start"
#Farbe der Körper
col=color.red
#Form der Körper
kugel = sphere(pos=vec(-1,0,0),visible=True, radius=0.1,color=col)#Punktmasse
stab = cylinder(visible=False, radius=0.1,color=col)
stab.pos=vector(0,0,0)
stab.axis=vector(l,0,0)
platte = box(visible=False,size=vec(a/10,a,a),axis=vec(0,1,0),color=col)
quader = box(visible=False,size=vec(a,a,a),color=col)
pyramide = pyramid(visible=False,pos=vec(0,-0.5,0),axis=vec(0,1,0),color=col)
#Vorauswahl für Kugel
currentobject = kugel
#Beschriftung
scene.caption = "Winkelgeschwindigkeit ändern: \n\n"
#Winkelgeschwindigkeit ermitteln
def winkelgeschwindigkeit(s):
    txtW.text = '{:1.2f}'.format(s.value)
#Slider für Winkelgeschwindigkeit  
sldW = slider(min=0, max=3, value=1.5, length=420, bind=winkelgeschwindigkeit, right=15)
#Textfeld für Ausgabe der Winkelgeschwindigkeit
txtW = wtext(text='{:1.2f}'.format(sldW.value))
#Einheit der Winkelgeschwindigkeit
scene.append_to_caption(' 1/s\n\n')
#Befehlsschaltfläche
button(text="Start",pos=scene.caption_anchor,bind=startStop)
#selbstdefinierte Funktion für Auswahl der Körper
def auswahl(m):
    global currentobject
    currentobject.visible = False
    val = m.selected
    #Kugel
    if val == "Kugel":
        currentobject = kugel
    #Stab
    elif val == "Stab":
        currentobject = stab
    #Platte
    elif val == "Platte":
        currentobject = platte
    elif  val == "Quader":
    #Quader
        currentobject = quader
    #Pyramide
    elif val == "Pyramide":
        currentobject = pyramide
    currentobject.visible = True
#Label für Ausgabe der Rotationsenergie 
lblErot=label(pos=vec(-0.1,1.2,0),text='<em>E</em><sub>rot</sub>  = %.1f J' %0)
#Menü für die Auswahl der Körper
scene.append_to_caption('\n\n')
menu(choices=['Wähle einen Körper', 'Kugel','Stab','Platte','Quader','Pyramide'], index=1, bind=auswahl)
#Animationsschleife
dt = 0.01
while True:
    rate(1/dt)
    w=sldW.value
    #Berechnung der Trägheitsmomente
    if currentobject == kugel:
        J=m*r**2  #Näherung, gilt nur für Punktmasse
    elif currentobject == stab:
        J=m*l**2/3
    elif currentobject == platte:
        J=m*(a**2+b**2)/12
    elif currentobject == quader:
        J=m*(a**2+b**2)/12
    elif currentobject == pyramide:
        J=m*a**2/10
    #Animation für die gewählten Objekte ausführen
    if running:
        #Drehachsen x,y,z, die Körper drehen sich um die y-Achse
        currentobject.rotate(angle=w*dt, axis=vector(0,1,0),origin=vec(0,0,0))
        Erot=0.5*J*w**2 #Rotationsenergie berechnen
        lblErot.text= '<em>E</em><sub>rot</sub> = %.2f J' %Erot #Ausgabe der Rotationsenergie

