#abb_09_01.py
import numpy as np
import matplotlib.pyplot as plt
from mpl_toolkits.axisartist.axislines import AxesZero
SIZE=12
plt.rcParams.update({'font.size': SIZE})
plt.rc('xtick', labelsize=SIZE)    
plt.rc('ytick', labelsize=SIZE)   
#Daten
x0=10
d=0.1
wd=3.14
phi=0
#NumPy-Array
t=np.arange(0,10,0.01)
#Schwingungsverlauf
x=x0*np.exp(-d*t)*np.cos(wd*t-phi)
#Einhüllende
xo=x0*np.exp(-d*t)
xu=-x0*np.exp(-d*t)
#Grafikbereich
fig = plt.figure(figsize=(12,6))
ax = fig.add_subplot(axes_class=AxesZero)
for direction in ["xzero", "yzero"]:
    ax.axis[direction].set_axisline_style("-|>")
    ax.axis[direction].set_visible(True)
#
for direction in ["left", "right", "bottom", "top"]:
    ax.axis[direction].set_visible(False)
#
ax.plot(t,x,'b-',lw=1.5)
ax.plot(t,xo,'r--')
ax.plot(t,xu,'r--')
ax.set_xlabel('Zeit')
ax.set_ylabel('Auslenkung')
plt.show()