#L_09_01.py
'''Simulation einer gedaempften Schwingung'''
import numpy as np
import matplotlib.pyplot as plt
from matplotlib.widgets import Slider
m=1 #Masse in kg
tmax=5
ymax=20
#gedaempfte Schwingung
def f(t,A,delta,k):
    w0=np.sqrt(k/m)
    wd=np.sqrt(w0**2-delta**2)
    return A*np.exp(-delta*t)*(w0/wd)*np.cos(2*np.pi*wd*t - np.arcsin(delta/w0))
#Änderungen abfragen
def update(val):
    A=sldA.val 
    b=sldB.val #Dämpfung
    k=sldK.val #Federkonstante
    delta=b/(2*m)
    txtDelta.set_text(r'$\delta$ = %2.1f 1/s' %delta)
    y.set_data(t,f(t,A,delta,k)) 
#Grafikbereich
fig, ax = plt.subplots(figsize=(10,8),label='Gedämpfte Schwingung')
fig.subplots_adjust(left=0.14,bottom=0.2)
ax.set_xlim(0,tmax)   #Wertebereich für x-Achse
ax.set_ylim(-ymax,ymax) #Wertebereich für y-Achse
t=np.linspace(0,tmax,200)
y, = ax.plot(t,f(t,5,0.2,4),'b-',lw=2) 
#x-, y-Position, Laenge, Hoehe
xyA = fig.add_axes([0.1, 0.09, 0.8, 0.03])
xyB = fig.add_axes([0.1, 0.05, 0.8, 0.03])
xyK= fig.add_axes([0.1, 0.01,  0.8, 0.03])
#Slider Objekte erzeugen
sldA=Slider(xyA,r'$A$',0,10, valinit=5,valstep=0.1)      #Amplitude
sldB=Slider(xyB,'$b$',0.0,1.99, valinit=0.2,valstep=0.01)#Dämpfung
sldK=Slider(xyK,'$k$',1,10, valinit=5.0,valstep=0.01)   #Federkonstante
#Änderungen durchfuehren
sldA.on_changed(update)
sldB.on_changed(update)
sldK.on_changed(update)
#Beschriftungen
txtDelta=ax.text(0.8*tmax,0.8*ymax,'')
ax.set(xlabel='t',ylabel='Auslenkung',title='Gedämpfte Schwingung')
plt.show()





