#L_09_03.py
#Gesamtenergie und Phasendiagramm für Federpendel
import numpy as np
import matplotlib.pyplot as plt
from scipy.integrate import solve_ivp
import numdifftools as nd
#Daten
m=1.0   #Masse kg
b=0.0  #Dämpfungskonstante in kg/s
k=1.0  #Federkonstante N/m
x0=5   #Anfangswert der Auslenkung
tmax=20
#DGL-System
def dgl(t,xa,k,m,d):
    x,v = xa
    dx_dt = v
    dv_dt = - b/m*v -k/m*x
    return dx_dt,dv_dt
#Lösung der DGL
t = np.linspace(0,tmax,500)
z=solve_ivp(dgl,[0,tmax],[x0,0],args=(k,m,b),dense_output=True)
x,v=z.sol(t)
#Energien berechnen
Es=0.5*k*x**2 #Spannenergie
Ek=0.5*m*v**2 #Bewegungsenergie
Eges=Es+Ek    #Gesamtenergie
#Grafikbereich
fig,ax = plt.subplots(3,2,figsize=(12,8),label='Feder-Masse-Schwinger')
ax[0,0].plot(t,x,'b-')  #Auslenkung
ax[1,0].plot(t,v,'r-')  #Geschwindigkeit
ax[0,1].plot(t,Es,'g-') #Spannenergie
ax[1,1].plot(t,Ek,'g-') #Bewegungsenergie
#Summe der Energien
ax[2,1].plot(t,Eges,'k-') 
ax[2,1].set_ylim(0,1.1*np.max(Eges))
#Phasendiagramm v=f(x)
ax[2,0].plot(x,v,'k-')
#Beschriftungen
ax[0,0].set(ylabel='$x$',title='Auslenkung')
ax[1,0].set(xlabel='Zeit',ylabel='$v$',title='Geschwindigkeit')
ax[0,1].set(ylabel='$E_{span}$',title='Spannenergie')
ax[1,1].set(ylabel='$E_{kin}$',title='Bewegungsergie')
ax[2,0].set(xlabel='$x$',ylabel='$v$',title='Phasendiagramm')
ax[2,1].set(xlabel='Zeit',ylabel='$E_{ges}$',title='Bewegungsenergie')
fig.tight_layout()
plt.show()

