#sci_federpendel.py
import numpy as np
import matplotlib.pyplot as plt
from scipy.integrate import solve_ivp
#Daten
m=1    #Masse kg
b=0.2  #Dämpfungskonstante in kg/s
k=1    #Federkonstante N/m
x0=5   #Anfangswert der Auslenkung
tmax=20
#DGL-System
def dgl(t,xa,k,m,d):
    x,v = xa
    dx_dt = v
    dv_dt = - b/m*v -k/m*x 
    return dx_dt,dv_dt
#Lösung der DGL
t = np.linspace(0,tmax,500)
z=solve_ivp(dgl,[0,tmax],[x0,0],args=(k,m,b),dense_output=True)
x,v=z.sol(t)
Es=0.5*k*x**2 #Spannenergie
Ek=0.5*m*v**2 #Bewegungsenergie
#Grafikbereich
fig,ax = plt.subplots(2,2,figsize=(10,8),label='Feder-Masse-Schwinger')
ax[0,0].plot(t,x,'b-')  #Auslenkung
ax[1,0].plot(t,v,'r-')  #Geschwindigkeit
ax[0,1].plot(t,Es,'g-') #Spannenergie
ax[1,1].plot(t,Ek,'g-') #Bewegungsenergie
#Beschriftungen
ax[0,0].set(ylabel='$x$',title='Auslenkung')
ax[1,0].set(xlabel='Zeit',ylabel='$v$',title='Geschwindigkeit')
ax[0,1].set(ylabel='$E_{span}$',title='Spannenergie')
ax[1,1].set(xlabel='Zeit',ylabel='$E_{kin}$',title='Bewegungsenergie')
fig.tight_layout()
plt.show()


#+ 10*np.sin(2*np.pi*t)

