#sci_phy_pendel.py
import numpy as np
import matplotlib.pyplot as plt
from scipy.integrate import solve_ivp
#Daten
l = 1.5    #Länge der Stange in m
ds = 0.05  #Durchmesser der Stange in m
dk = 0.2   #Durchmesser der Kugel in m
phi0 = 60  #Auslenkung in °
g=9.81     #Erdbeschleunigung m/s^2
#Funktionsdefinition für Trägheitsmoment
def pendel(l,ds,dk):
    R=dk/2
    rho=7850  #Dichte von Stahl kg/m^3
    ms=rho*np.pi*(ds/2)**2*l #Masse der Stange
    mk=rho*4/3*np.pi*R**3    #Masse der Kugel
    m=ms+mk                  #Gesamtmasse
    ls=l*(0.5*ms+mk)/m
    J=mk*l**2*(1+2/5*R**2/l**2+1/3*ms/mk)
    return m,ls,J
#DGL-System
def dgl(t,a0,w02):
    phi,w = a0
    dphi_dt = w
    dw_dt =  -w02*np.sin(phi) 
    return dphi_dt,dw_dt
#Berechnung der Frequenz und Periodendauer
m,ls,J = pendel(l,ds,dk)
w02=m*g*ls/J  #Quadrat der Kreisfrequenz
T=2*np.pi/np.sqrt(w02) #Schwingungsdauer
f=1/T
#Lösung der DGL
t = np.linspace(0,2*T,800)
z=solve_ivp(dgl,[0,2*T],[np.radians(phi0),0],args=(w02,),dense_output=True)
phi, w = z.sol(t)
h=ls*(1-np.cos(phi)) #Höhe
Epot = m*g*h         #potentielle Energie
Ekin = 0.5*J*w**2    #kinetische Energie
Eges=Epot+Ekin
#Grafikbereich
fig,ax = plt.subplots(2,2,figsize=(10,8),label='Physikalisches Pendel')
#linke Spalte
ax[0,0].plot(t,np.degrees(phi),'r-',lw=1.5)  #Auslenkung
ax[1,0].plot(t,w,'b-',lw=1.5)     #Winkelgeschwindigkeit
#rechte Spalte
ax[0,1].plot(t,Epot,'r-',lw=1.5)  #potentielle Energie
ax[0,1].plot(t,Ekin,'b-',lw=1.5)  #kinetische Energie
ax[1,1].set_ylim(0,1.1*np.max(Eges))
ax[1,1].plot(t,Eges,'k-',lw=1.5)
#Beschriftungen
ax[0,0].set(ylabel=r'$\varphi$ in °',title='Auslenkung')
ax[1,0].set(xlabel='$t$ in s',ylabel=r'$\omega$ in rad/s')
ax[1,0].set_title('T = %2.2f s   f = %2.2f Hz' %(T,f))
ax[0,1].set_title('potentielle und kinetische Energie')
ax[0,1].set(ylabel=r'$E_{pot}$   $E_{kin}$ in J')
ax[1,1].set_title('Gesamtenergie')
ax[1,1].set(xlabel='$t$ in s',ylabel='$E_{ges}$ in J')
fig.tight_layout()
plt.show()






#ax[1,1].set_title('Gesamtenergie $E_{ges} = %1.3f \,\mathrm{kgm^2}$'%J)
