#sym_federpendel.py
from sympy import *
from sympy.plotting import plot, PlotGrid
t = symbols('t')
x = Function('x')(t)
m=1   #Masse in kg
b=0   #Dämpfungskonstante in kg/s
k=1   #Federkonstante in N/m #4*pi**2 
dgl=Eq(x.diff(t,2) + b/m*x.diff(t,1) + k/m*x,0) #DGL 2. Ordnung
#Anfangswerte
aw={
    x.subs(t,0):5,           #Auslenkung
    x.diff(t,1).subs(t,0):0  #Anfangsgeschwindigkeit
    }
#Lösung der DGL
aL=dsolve(dgl)                 #allgemeine Lösung der DGL
sL=dsolve(dgl,ics=aw).evalf(3) #spezielle Lösung der DGL
x_t = sL.rhs.evalf(3)          #rechte Seite der Funktion
v_t = diff(x_t,t,1).evalf(3)   #Geschwindigkeit, 1. Ableitung
a_t = diff(x_t,t,2).evalf(3)   #Beschleunigung,  2. Ableitung
#Ausgaben
print("allgemeine Lösung\n",aL)
print("spezielle Lösung\n",sL)
print("Auslenkung\nx(t) =",x_t)
print("Geschwindigkeit\nv(t) =",v_t)
print("Beschleunigung\na(t) =",a_t)
#Funktionsplots
p1=plot(x_t,(t,0,20),ylabel='Auslenkung',line_color='blue',show=False)
p2=plot(v_t,(t,0,20),ylabel='Geschwindigkeit',line_color='green',show=False)
p3=plot(a_t,(t,0,20),ylabel='Beschleunigung',line_color='red',show=False)
p = PlotGrid(3, 1, p1, p2, p3,size=(8,8))

# p.save("/Users/veit/documents/Python_Mechanik/Bilder/48223_09-NF002.svg")
# p.save("/Users/veit/documents/Python_Mechanik/Bilder/48223_09-NF002.pdf")


