#plot_lissajours.py
import numpy as np
import matplotlib.pyplot as plt
#x-Komponente
def x(t,w):
    return np.sin(w*t)
#y-Komponente
def y(t,w,phi):
    return np.sin(w*t - phi)
#Grafikbereich
fig, ax=plt.subplots(4,3,figsize=(9,12),label="Lissajours'sche Figuren")
t=np.linspace(0,2*np.pi,500)
liste=[(0,0,1,1,0),(0,1,1,1,np.pi/4),(0,2,1,1,np.pi/2),
       (1,0,1,2,0),(1,1,1,2,np.pi/4),(1,2,1,2,np.pi/2),
       (2,0,1,3,0),(2,1,1,3,np.pi/4),(2,2,1,3,np.pi/2),
       (3,0,2,3,0),(3,1,2,3,np.pi/4),(3,2,2,3,np.pi/2)]
for i,j,n,m,phi in liste:
    ax[i,j].plot(x(t,n),y(t,m,phi))
    ax[i,j].set_xticks([])
    ax[i,j].set_yticks([])
#Beschriftungen
ax[0,0].set_title(r'$\varphi=0$')
ax[0,1].set_title(r'$\varphi=\pi/4$')
ax[0,2].set_title(r'$\varphi=\pi/2$')
ax[0,0].set_ylabel('1:1')
ax[1,0].set_ylabel('1:2')
ax[2,0].set_ylabel('1:3')
ax[3,0].set_ylabel('2:3')
fig.tight_layout()
#fig.savefig("/Users/veit/documents/Python_Mechanik_01/zusatz/lissajours.svg")
plt.show()
              

