#sci_gekoppeltes_fadenpendel.py 
import numpy as np
import matplotlib.pyplot as plt
from scipy.integrate import solve_ivp
#Pendeldaten
auslenkung1 = -20 #Auslenkung Pendel 1 in °
auslenkung2 = 0   #Auslenkung Pendel 2 in °
l = 0.2      #Pendellaengen in m
m = 0.2      #Pendelmassen in kg
c = 1        #Federkonstante N/m
g = 9.81     #Erdbeschleunigung in m/s^2
tmax=10
phi01,phi02=np.radians(auslenkung1),np.radians(auslenkung2)
#DGL-System, der Unterstrich bedeutet 1. Ableitung nach der Zeit
def dgl(t,phi0,l, m, c):
    phi1,w1,phi2,w2 = phi0
    phi1_dt=w1
    w1_dt=-g/l*phi1-c/m*(phi1-phi2)
    phi2_dt=w2
    w2_dt=-g/l*phi2+c/m*(phi1-phi2)
    return phi1_dt, w1_dt, phi2_dt, w2_dt
#Anfangswerte
omega01 = omega02 = 0
phi0 =[phi01,omega01,phi02,omega02]
#Loesung des DGL-Systems
t = np.linspace(0,tmax,500)
z=solve_ivp(dgl,[0,tmax],phi0,args=(l,m,c),dense_output=True)
phi1,w1,phi2,w2=z.sol(t)
#Grafikbereich
fig,axes=plt.subplots(2,2,figsize=(10,8))
#Auslenkung Pendel 1
axes[0,0].plot(t,np.degrees(phi1),"r-",lw=2)
#Auslenkung Pendel 2
axes[0,1].plot(t,np.degrees(phi2),"r-",lw=2)
#Winkelgeschwindigkeit Pendel 1
axes[1,0].plot(t,w1,'b-',lw=2)
#Winkelgeschwindigkeit Pendel 2
axes[1,1].plot(t,w2,"b-",lw=2)
#Beschriftungen
axes[0,0].set_title("Pendel 1")
axes[1,0].set_xlabel("$t$ in s")
axes[1,0].set_ylabel(r"$\omega_{1}$ in rad/s")
axes[0,0].set_ylabel(r"$\varphi_{1}$ in °",)
axes[0,1].set_title("Pendel 2")
axes[0,1].set_ylabel(r"$\varphi_{2}$ in °")
axes[1,1].set_ylabel(r"$\omega_{2}$ in rad/s")
axes[1,1].set_xlabel("$t$ in s")
for i,j in [[0,0],[0,1],[1,0],[1,1]]:axes[i,j].grid(True)
fig.tight_layout()
#fig.savefig('/Users/veit/documents/Python_Mechanik_01/zusatz/gekoppeltes_fadenpendel.svg')
plt.show()

'''
Quelle für DGL-System
Ahrens: Mathematik, S. 1052
'''


