#sym_gekoppeltes_federpendel.py
from sympy import symbols,Eq,Function,plot,N
from sympy.solvers.ode.systems import dsolve_system
t = symbols("t")
x1 = Function("x1")(t)
x2 = Function("x2")(t)
m1,m2=2,2     #Massen
c1,c2=10,10   #Federkonstanten
d1,d2=0.1,0.1 #Dämpfungen
#DGL-System
dgl1=Eq(m1*x1.diff(t,2) + d1*x1.diff(t,1) + c1*x1 - c2*(x2-x1),0) 
dgl2=Eq(m2*x2.diff(t,2) + d2*x2.diff(t,1) + c2*(x2-x1),0)
#Anfangswerte
aw={
    x1.subs(t,0): 0.1, 
    x2.subs(t,0):-0.1,
    x1.diff(t,1).subs(t,0):0,
    x2.diff(t,1).subs(t,0):0
    }
#Lösung des DGL-Systems
gleichungen = [dgl1,dgl2]
aL=dsolve_system(gleichungen)        #allgemeine Lösung
sL=dsolve_system(gleichungen,ics=aw) #spezielle Lösung
gX1=sL[0][0].rhs 
gX2=sL[0][1].rhs
#Ausgaben
# print("allgemeine Lösung\n",aL)
# print("spezielle Lösung")
# print("x1(t) =",N(gX1,3))
# print("x2(t) =",N(gX2,3))
p=plot(gX1,gX2,(t,0,10),show=False,legend=True)
p.xlabel='t'
p.ylabel='Auslenkung'
p[0].line_color='blue'
p[0].label='x1'
p[1].line_color='red'
p[1].label='x2'
#p.save('/Users/veit/documents/Python_Mechanik_01/zusatz/plot_gekoppeltes_fadenpendel.svg')
p.show()

