#abb_10_02.py
#Wellenausbreitung: Zeitbild und Ortsbild
#Unterdiagramme nebeneinander
import numpy as np
import matplotlib.pyplot as plt
#Daten
A=0.5 #Amplitude
f=1   #Frequenz in Hz
v=1   #Ausbreitungsgeschwindigkeit in m/s
#Berechnungen
w =  2*np.pi*f    #Kreisfrequenz
T =  1/f          #Periodendauer
lam=f/v           #Wellenlänge
k=2*np.pi/lam     #Kreiswellenzahl
#Wertebereich
t = np.linspace(0, T, 500) #Zeitbereich
x = np.linspace(0,lam,500) #Ausdehnung der Welle
#Funktionsdefinition
y1=A*np.sin(w*t) #Zeitbild
y2=A*np.sin(k*x) #Ortsbild
#zwei Unterdiagramme nebeneinander
fig, ax = plt.subplots(1,2,figsize=(10,3))
#Zeitbild
ax[0].spines[['top', 'right']].set_visible(False)
ax[0].spines[['left','bottom']].set_position(("data", 0))
ax[0].plot(t, y1,'b-',lw=1.5)
ax[0].plot(1,0,'>k',transform=ax[0].get_yaxis_transform(),clip_on=False)
ax[0].plot(0,1,'^k',transform=ax[0].get_xaxis_transform(),clip_on=False)
#Ortsbild
ax[1].spines[['top', 'right']].set_visible(False)
ax[1].spines[['left','bottom']].set_position(("data", 0))
ax[1].plot(x,y2,'r-',lw=1.5)
ax[1].plot(1,0,'>k',transform=ax[1].get_yaxis_transform(),clip_on=False)
ax[1].plot(0,1,'^k',transform=ax[1].get_xaxis_transform(),clip_on=False)
#Beschriftungen
ax[0].set_title('Zeitbild')
ax[0].set_xlabel('$t$',loc='right')
ax[0].set_ylabel('$y$',loc='top',rotation=0)
ax[0].text(0.95,0.05,r'$T=\frac{2\pi }{\omega } $',fontsize=12)
ax[1].set_title('Ortsbild')
ax[1].set_xlabel('$x$',loc='right')
ax[1].set_ylabel('$y$',loc='top',rotation=0)
ax[1].text(0.95,0.05,r'$\lambda =\frac{2\pi }{k} $',fontsize=12)
#fig.tight_layout()
plt.show()

'''
fig.savefig("/Users/veit/documents/Python_Mechanik/Bilder/48223_10-NF002.svg")
fig.savefig("/Users/veit/documents/Python_Mechanik/Bilder/48223_10-NF002.pdf")
'''


