#ani_stehede_welle.py
import numpy as np
import matplotlib.pyplot as plt
from matplotlib.animation import FuncAnimation
#Daten
L=20      #Länge des Seils in m
my=0.5    #Seilmasse pro Meter in kg/m
Fs=50     #Spannkraft in N
v=np.sqrt(Fs/my) #10 m/s
f0=v/L/2
ymax=0.25 #Amplidude der Auslenkung in m
dt=2e-2   #Zeitschrittweite
#Funktionsdefinitionen für stehende Welle
def welle(t,n):
    f=n*f0
    lamda = v/f
    k=2*np.pi/lamda
    return 2*ymax*np.sin(k*x)*np.cos(2*np.pi*f*t)
#Änderung der Auslenkung   
def seil(i):
    t=i*dt
    y1=welle(t,1)
    y2=welle(t,2)
    y3=welle(t,3)
    linie1.set_data(x,y1)
    linie2.set_data(x,y2)
    linie3.set_data(x,y3)
    return linie1,linie2,linie3
#Grafikbereich
fig, ax = plt.subplots(3,1,figsize=(9,9))
ax[0].axis([0,L,-2.3*ymax,2.3*ymax])
ax[1].axis([0,L,-2.3*ymax,2.3*ymax])
ax[2].axis([0,L,-2.3*ymax,2.3*ymax])
x = np.arange(0,L,dt)
linie1, = ax[0].plot([],[],'b-',lw=2)
linie2, = ax[1].plot([],[],'g-',lw=2)
linie3, = ax[2].plot([],[],'r-',lw=2)
ani = FuncAnimation(fig,seil,interval=10,blit=True,save_count=500)
#Beschriftungen
ax[0].set_title('Frequenz $f_0$ = %2.2f Hz' %f0)
ax[1].set_title('Frequenz $f_1$ = %2.2f Hz' %(2*f0))
ax[2].set_title('Frequenz $f_2$ = %2.2f Hz' %(3*f0))
ax[0].set_ylabel('$y$')
ax[1].set_ylabel('$y$')
ax[2].set_ylabel('$y$')
ax[2].set_xlabel('$x$')
fig.tight_layout()
plt.show()



'''
schwingende Saite
y(x,t)=[2*ym*sin(k*x)]*cos(w*t)
Halliday S. 483
'''
