#ani_transversalwelle.py
import numpy as np
import matplotlib.pyplot as plt
from matplotlib.animation import FuncAnimation
#Daten
N = 61         #Anzahl der Knoten
L = 20         #Seillänge in m
ymax = 0.5     #Amplitude in m 
f = 2.0        #Anregungsfrequenz in Hz
my=0.5         #kg/m
Fs=50          #Spannkraft in N
dt = 5e-3      #Zeitschrittweite in s
#Berechnungen
v=np.sqrt(Fs/my)    #Phasengeschwindigkeit
lamda = v/f         #Wellenlänge in m
w = 2*np.pi*f       #Kreisfrequenz in rad/s
k = 2*np.pi/lamda   #Wellenzahl in rad/m
T=1/f               #Schwingungsdauer in s
Pm=0.5*my*v*w**2*ymax**2 #gemittelte Leistung der Welle in W
xmitte=N//2
#Aktualisierung der Funktionswerte
def transversalwelle(i):
    t = i*dt
    y = ymax*np.cos(k*x - w*t)
    seil.set_data(x,y)
    punkt.set_data([x[xmitte]],[y[xmitte]])
    return seil,punkt
#Grafikbereich
fig, ax = plt.subplots(figsize=(10,5))
x = np.linspace(0,L,N)
ax.axis([0,L,-1.5*ymax,1.5*ymax])
ax.hlines(0,L,0,color='black') #x-Achse
ax.vlines(x[xmitte],-ymax,ymax,color='black',ls='--')
seil, = ax.plot([],[], 'bo:')
punkt, = ax.plot([],[],'ro')
ani = FuncAnimation(fig,transversalwelle,interval=20,blit=True,save_count=500)
#Beschriftungen
ax.set_xlabel('$x$ in m')
ax.set_ylabel('$y$ in m')
ax.set_title('$T$ = %.1f s \t  $v$  = %.1f m/s \t $P_m$ = %.1f W ' %(T,v,Pm))
plt.show()

# seil, punkt = ax.plot([],[],'bo:',[],[],'ro')

