#ani_welle.py
import numpy as np
import matplotlib.pyplot as plt
from matplotlib.animation import FuncAnimation
#Daten
v = 10    #Ausbreitungsgeschwindigkeit m/s
f = 1     #Frequenz in Hz  
dt=1e-2   #Zeitschrittweite in s
lamda=v/f #Wellenlänge in m
w=2*np.pi*f     #Kreisfrequenz 1/s
k=2*np.pi/lamda #Wellenzahl
xmax,ymax=20,0.5
#Wellengleichung
def welle(i):
    t=i*dt
    y=ymax*np.sin(w*t - k*x)
    linie.set_data(x,y) 
    return linie,
#Grafikbereich
fig, ax = plt.subplots(label='Transversalwelle')
x = np.linspace(0,xmax,500)
ax.axis([0,xmax,-1.2*ymax,1.2*ymax])
linie, = ax.plot([],[],'b-')
ani = FuncAnimation(fig,welle,interval=20,blit=True,save_count=500)
#Beschriftungen
ax.set_title(r'$\lambda$ = %1.1f m,  $k$ = %1.3f 1/m' %(lamda,k))
ax.set_xlabel('$x$ in m')
ax.set_ylabel('$y$ in m')
plt.show()

# ani = FuncAnimation(fig,welle,frames=x.size,interval=20,blit=True)




