#L_10_03.py
'''
Simulation der der Verschiebung einer Transversalvelle mit einem Slider
'''
import numpy as np
import matplotlib.pyplot as plt
from matplotlib.widgets import Slider
#Daten
f=1 #Frequenz in Hz
k=1
T=1/f
ymax=1    
xmax=10
#Funktionsdefinitionen
def welle(t,x):
    return ymax*np.sin(2*np.pi*f*t - k*x)
#Änderungen abfragen
def update(val):
    xv = sldX.val
    y=welle(t,xv) 
    kurve.set_data(x,y)
#Grafikbereich
fig,ax=plt.subplots(label='Überlagerung von Wellen')
ax.axis([0, xmax, -2.2*ymax, 2.2*ymax])
fig.subplots_adjust(left=0.12,bottom=0.25)
x=np.linspace(0,xmax,200)
t=np.linspace(0,T,200)
kurve, = ax.plot(x,welle(t,0),'b-',lw=1)
#Objekte für Steuerelemente platzieren
#linker Rand, unterer Rand, Breite, Höhe
xyX =fig.add_axes([0.05, 0.1, 0.83, 0.03])
#Objekt für Steuerelemente erzeugen
sldX=Slider(xyX,'$x$',0,np.pi,valinit=0,valstep=0.01)
#Ereignisverarbeitung
sldX.on_changed(update)
#Beschriftungen
ax.set_xlabel('$x$ in m')
ax.set_ylabel('Auslenkung')
plt.show()



