#!/usr/bin/env python3
#vp_welle.py
from vpython import *
scene.userzoom=False
colorVector = vec(0,1,1) 
scene.width = scene.height = 600
scene.background = color.white
L = 50
scene.center = vec(0.05*L,0.2*L,0)
scene.range = 1.3*L
#Klassendefinition
class plot3D:
    def __init__(self, f, xmin, xmax, ymin, ymax, zmin, zmax):
        # The x axis is labeled y, the z axis is labeled x, and the y axis is labeled z.
        # This is done to mimic fairly standard practive for plotting
        #     the z value of a function of x and y.
        self.f = f
        if not xmin: self.xmin = 0
        else: self.xmin = xmin
        if not xmax: self.xmax = 1
        else: self.xmax = xmax
        if not ymin: self.ymin = 0
        else: self.ymin = ymin
        if not ymax: self.ymax = 1
        else: self.ymax = ymax
        if not zmin: self.zmin = 0
        else: self.zmin = zmin
        if not zmax: self.zmax = 1
        else: self.zmax = zmax
        
        self.vertices = []
        for x in range(L):
            for y in range(L):
                val = self.evaluate(x,y)
                self.vertices.append(self.make_vertex( x, y, val ))
        
        self.make_quads()
        self.make_normals()
        
    def evaluate(self, x, y):
        d = L-2
        return (d/(self.zmax-self.zmin))*(self.f(self.xmin+x*(self.xmax-self.xmin)/d, self.ymin+y*(self.ymax-self.ymin)/d)-self.zmin)
    
    def make_quads(self):
        # Create the quad objects, based on the vertex objects already created.
        for x in range(L-2):
            for y in range(L-2):
                v0 = self.get_vertex(x,y)
                v1 = self.get_vertex(x+1,y)
                v2 = self.get_vertex(x+1, y+1)
                v3 = self.get_vertex(x, y+1)
                quad(vs=[v0, v1, v2, v3])
        
    def make_normals(self):
        # Set the normal for each vertex to be perpendicular to the lower left corner of the quad.
        # The vectors a and b point to the right and up around a vertex in the xy plance.
        for i in range(L*L):
            x = int(i/L)
            y = i % L
            if x == L-1 or y == L-1: continue
            v = self.vertices[i]
            a = self.vertices[i+L].pos - v.pos
            b = self.vertices[i+1].pos - v.pos
            v.normal = cross(a,b)
    
    def replot(self):
        for i in range(L*L):
            x = int(i/L)
            y = i % L
            v = self.vertices[i]
            v.pos.y = self.evaluate(x,y)
        self.make_normals()
                
    def make_vertex(self,x,y,value):
        return vertex(pos=vec(y,value,x),color=colorVector,normal=vec(0,1,0))
        
    def get_vertex(self,x,y):
        return self.vertices[x*L+y]
        
    def get_pos(self,x,y):
        return self.get_vertex(x,y).pos
#Wellenfunktion
t = 0
def f(x,y):
    #return 0.7+0.2*sin(10*x)*cos(10*y)*sin(5*t) #stehnde Welle erzeugen
    return 0.7+0.2*sin(5*t - 10*x)
#function, xmin, xmax, ymin, ymax (defaults 0, 1, 0, 1, 0, 1)
p = plot3D(f, 0, 1, 0, 1, 0, 1) #das Objekt p aus der Klasse plot3D erzeugen
#Animation starten und anhalten
run = False
def startStop(b):
    global run
    run = not run
    if run: b.text = "Stop"
    else: b.text = "Start"
#Steuerelement Befehlsschaltfläche
button(bind=startStop,text="Start")
#Positionierung der Welle
scene.forward = vec(-0.7,-0.5,-1)
#Animationsschleife
dt = 0.02 #Zeitschrittwweite
while True:
    rate(30)
    if run:
        p.replot()
        t = t + dt
        
'''
Quelle:
https://www.glowscript.org/#/user/GlowScriptDemos/folder/Examples/program/Plot3D
'''
