#vp_welle_ki.py
from vpython import *
# Szene einrichten
scene = canvas(title='Mechanische Welle', width=800, height=600, center=vector(0,0,0))
scene.background = color.white #hinzugefügt
# Parameter der Welle
amplitude = 1
wavelength = 4
k = 2*pi/wavelength
omega = 2*pi/2  # Periodendauer von 2 Sekunden
speed = omega/k
# Anzahl der Punkte
num_points = 100
x_start = -5
x_end = 5
dx = (x_end - x_start)/(num_points - 1)
# Erstelle die Punkte der Welle
points = []
for i in range(num_points):
    x = x_start + i*dx
    y = amplitude*sin(k*x)
    point = sphere(pos=vector(x, y, 0), radius=0.05, color=color.blue)
    points.append(point)
# Animationsschleife
t = 0
dt = 0.01
while True:
    rate(100)
    t += dt
    for i, point in enumerate(points):
        x = point.pos.x
        y = amplitude*sin(k*x - omega*t)
        point.pos.y = y


'''
Quelltext am 15.06.2025 mit ChatGPT Deutsch erzeugt.
Eingabetext:
Schreibe ein VPython Programm, das eine mechanische Welle animiert.
'''
        